<?php
/**
 * SMSTunnel Uninstall
 *
 * Removes all plugin data when uninstalled.
 *
 * @package SMSTunnel
 * @author Narcis Bodea <contact@narboweb.ro>
 * @copyright 2024-2025 NARBOWEB SRL
 */

// Exit if accessed directly or not uninstalling
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
$smstunnel_options_to_delete = array(
    'smstunnel_api_key',
    'smstunnel_server_url',
    'smstunnel_2fa_enabled',
    'smstunnel_2fa_roles',
    'smstunnel_language',
    'smstunnel_site_token',
    'smstunnel_setup_status',
    'smstunnel_setup_device',
    'smstunnel_setup_timestamp',
    'smstunnel_setup_error',
    'smstunnel_public_key',
    'smstunnel_private_key_encrypted',
    'smstunnel_encryption_iv',
);

foreach ($smstunnel_options_to_delete as $smstunnel_option) {
    delete_option($smstunnel_option);
}

// Delete user meta for 2FA
$smstunnel_users = get_users(array('fields' => 'ID'));
foreach ($smstunnel_users as $smstunnel_user_id) {
    delete_user_meta($smstunnel_user_id, 'smstunnel_phone');
    delete_user_meta($smstunnel_user_id, 'smstunnel_2fa_enabled');
}

// Delete transients
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Uninstall cleanup
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_smstunnel_%'");
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Uninstall cleanup
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_smstunnel_%'");

// Drop custom table
$smstunnel_table_name = $wpdb->prefix . 'smstunnel_log';
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Uninstall cleanup
$wpdb->query("DROP TABLE IF EXISTS {$smstunnel_table_name}");
