<?php
/**
 * Uninstall SMSTunnel Formidable Forms
 *
 * Removes all plugin data when uninstalled.
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Formidable stores action settings as posts
// Delete all SMSTunnel SMS actions when uninstalling
// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query -- Required to find SMS actions for cleanup
$smstunnel_frm_actions = get_posts(array(
    'post_type'      => 'frm_form_actions',
    'posts_per_page' => -1,
    'meta_query'     => array(
        array(
            'key'     => 'frm_action_type',
            'value'   => array('smstunnel_sms', 'smstunnel_sms_2'),
            'compare' => 'IN',
        ),
    ),
));

foreach ($smstunnel_frm_actions as $smstunnel_frm_action) {
    wp_delete_post($smstunnel_frm_action->ID, true);
}
