<?php
/**
 * Uninstall SMSTunnel Events Calendar
 *
 * Removes all plugin data when uninstalled
 */

// Exit if accessed directly
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('smstunnel_tec_settings');

// Clean up cron events
wp_clear_scheduled_hook('smstunnel_tec_send_reminders');

// Optionally clean up post meta (commented out by default to preserve data)
// Uncomment if you want to remove all SMS-related meta on uninstall
/*
global $wpdb;

// Delete event meta
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_smstunnel_%'");

// Delete attendee meta
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_smstunnel_attendee_%'");
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_smstunnel_reminder_sent_%'");
*/

// Clear any transients
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall cleanup
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_smstunnel_event_%'");
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall cleanup
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_smstunnel_event_%'");
